"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNextMonthDate = exports.isDateValid = exports.monthDifference = exports.amountWithInterest = exports.generateRandomNumber = exports.prettyError = exports.deleteFile = exports.uploadImage = exports.smsApiError = exports.generateOTP = exports.sendToken = exports.ApiError = exports.ErrorHandler = exports.requestHandler = void 0;
const date_fns_1 = require("date-fns");
const fs = __importStar(require("fs/promises"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const multer_1 = __importDefault(require("multer"));
const path_1 = __importDefault(require("path"));
const config_1 = __importDefault(require("../config"));
/**
 *
 * @param handler An Express Request Handler Function
 * @param config An Optional Object That Takes Zod Schema as Request Query, Body, Params To Validate
 * @returns Promise<void> | Promise<NextFunction>
 */
const requestHandler = (handler, config) => {
    return async (req, res, next) => {
        await Promise.resolve(handler(req, res, next)).catch((err) => {
            console.log(err);
            return ApiError(err, 404, next);
        });
    };
};
exports.requestHandler = requestHandler;
class ErrorHandler extends Error {
    message;
    statusCode;
    constructor(message, statusCode) {
        super(message);
        this.message = message;
        this.statusCode = statusCode;
        Error.captureStackTrace(this);
    }
}
exports.ErrorHandler = ErrorHandler;
function ApiError(err, statusCode = 500, next) {
    return next(new ErrorHandler((0, exports.prettyError)(err, "API Error"), statusCode));
}
exports.ApiError = ApiError;
const sendToken = (res, user, next) => {
    if (!user) {
        return ApiError("User not found", 404, next);
    }
    const token = jsonwebtoken_1.default.sign({ sub: user.id, mobile: user.mobile }, config_1.default.JWT_SECRET, {
        expiresIn: "365d",
    });
    if (!token) {
        return ApiError("Please Login Again There are some unexpected error", 404, next);
    }
    const { password, ...userWithoutPass } = user;
    res.status(200).json({
        user: userWithoutPass,
        accessToken: token,
    });
};
exports.sendToken = sendToken;
function generateOTP(len) {
    let otp = "";
    for (let i = 0; i < len; i++) {
        otp += Math.floor(Math.random() * 10).toString();
    }
    return otp;
}
exports.generateOTP = generateOTP;
exports.smsApiError = {
    1002: "Sender Id/Masking Not Found",
    1003: "API Not Found",
    1004: "SPAM Detected",
    1005: "Internal Error",
    1006: "Internal Error",
    1007: "Balance Insufficient",
    1008: "Message is empty",
    1009: "Message Type Not Set (text/unicode)",
    1010: "Invalid User & Password",
    1011: "Invalid User Id",
    1012: "Invalid Number",
    1013: "API limit error",
    1014: "No matching template",
    1015: "SMS Content Validation Fails",
    404: "Mobile Not found",
    500: "Internal Error",
};
/**
 * Upload Using Multer
 */
const storage = multer_1.default.diskStorage({
    destination: (req, file, cb) => {
        cb(null, "uploads");
    },
    filename: (req, file, cb) => {
        cb(null, Date.now() + "-" + file.originalname);
    },
});
exports.uploadImage = (0, multer_1.default)({
    storage: storage,
    fileFilter: function (req, file, callback) {
        const ext = path_1.default.extname(file.originalname);
        if (ext !== ".png" &&
            ext !== ".jpg" &&
            ext !== ".gif" &&
            ext !== ".jpeg" &&
            ext !== ".svg" &&
            ext !== ".webp" &&
            ext !== ".avif" &&
            ext !== ".pdf") {
            return callback(new Error("Only images and PDF are allowed"));
        }
        callback(null, true);
    },
});
/**
 * Delete File
 */
const deleteFile = async (filePath, next) => {
    try {
        if (!filePath)
            throw new Error("File not found");
        await fs.unlink(filePath);
    }
    catch (error) {
        throw new Error(error);
    }
};
exports.deleteFile = deleteFile;
const prettyError = (err, from) => {
    let errMessage = "";
    if (err instanceof Error) {
        errMessage = err.message;
    }
    else if (typeof err === "string") {
        errMessage = err;
    }
    console.log(err);
    const cause = errMessage.split("'")[1] || errMessage.split('"')[1];
    if (err?.errno === 1451) {
        errMessage =
            "Cannot delete this data, Maybe some other data connected with this";
    }
    if (errMessage.includes("Duplicate")) {
        errMessage = `${from} already exists with ${cause}`;
    }
    else if (errMessage.includes("not find")) {
        errMessage = `${cause} not found with ${JSON.stringify(err?.criteria)}`;
    }
    else {
        errMessage = errMessage;
    }
    return errMessage;
};
exports.prettyError = prettyError;
const generateRandomNumber = (length) => {
    let result = "";
    const characters = "0123456789";
    const charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return parseInt(result);
};
exports.generateRandomNumber = generateRandomNumber;
const amountWithInterest = (amount, interest) => {
    return amount + (amount / 100) * interest || 0;
};
exports.amountWithInterest = amountWithInterest;
function monthDifference(date1, date2) {
    const year1 = date1.getFullYear();
    const month1 = date1.getMonth(); // getMonth() is zero-based (0 for January, 11 for December)
    const year2 = date2.getFullYear();
    const month2 = date2.getMonth();
    // Calculate the difference in months
    const yearDiff = year2 - year1;
    const monthDiff = month2 - month1;
    return yearDiff * 12 + monthDiff;
}
exports.monthDifference = monthDifference;
const isDateValid = (startDate, endDate) => {
    const start = (0, date_fns_1.parseISO)(startDate);
    const end = (0, date_fns_1.parseISO)(endDate);
    // Check if start date is before or equal to the end date
    return (0, date_fns_1.isBefore)(start, end) || (0, date_fns_1.isEqual)(start, end);
};
exports.isDateValid = isDateValid;
function getNextMonthDate(date) {
    return (0, date_fns_1.addMonths)(date, 1);
}
exports.getNextMonthDate = getNextMonthDate;
//# sourceMappingURL=index.js.map