"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userRoutes = void 0;
const express_1 = require("express");
const controller_1 = require("../controller");
const isAuth_1 = require("../middleware/isAuth");
exports.userRoutes = (0, express_1.Router)();
const { createUser, loginUser, currentUser, createAdmin, getUser } = new controller_1.UserController();
exports.userRoutes.post('/create-user-by-admin', isAuth_1.isAuthenticated, createUser);
exports.userRoutes.post('/create-admin', createAdmin);
exports.userRoutes.post('/login', loginUser);
exports.userRoutes.get('/current', isAuth_1.isAuthenticated, currentUser);
exports.userRoutes.get("/", getUser);
//# sourceMappingURL=user.js.map