"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.projectRoutes = void 0;
const express_1 = require("express");
const controller_1 = require("../controller");
const utils_1 = require("../utils");
exports.projectRoutes = (0, express_1.Router)();
const { addProject, getProjects, addDelivery, uploadDocuments, getDelivery, updateStatus, uploadDeliveryDocuments, addOrder, removeOrder } = new controller_1.ProjectController();
exports.projectRoutes.route("/").get(getProjects).post(addProject);
exports.projectRoutes
    .route("/delivery")
    .post(utils_1.uploadImage.single("file"), addDelivery)
    .get(getDelivery)
    .patch(updateStatus);
exports.projectRoutes.post("/documents", utils_1.uploadImage.single("file"), uploadDocuments);
exports.projectRoutes.post("/delivery/document", utils_1.uploadImage.single("file"), uploadDeliveryDocuments);
exports.projectRoutes.post("/add-order", addOrder);
exports.projectRoutes.patch("/remove-order", removeOrder);
//# sourceMappingURL=project.js.map