"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.depositRoutes = void 0;
const express_1 = require("express");
const utils_1 = require("../utils");
const orm_config_1 = require("../orm.config");
const entities_1 = require("../entities");
exports.depositRoutes = (0, express_1.Router)();
exports.depositRoutes.get("/", (0, utils_1.requestHandler)(async (req, res, next) => {
    try {
        const qb = orm_config_1.appDataSource
            .getRepository(entities_1.SavingDeposit)
            .createQueryBuilder("s")
            .leftJoinAndSelect("s.customer", "c");
        if (req.query.startDate && req.query.endDate) {
            const isDate = (0, utils_1.isDateValid)(req.query.startDate, req.query.endDate);
            if (!isDate) {
                throw new utils_1.ErrorHandler("Invalid Date", 404);
            }
            qb.andWhere("DATE(s.created_at) BETWEEN :startDate AND :endDate", {
                startDate: req.query.startDate,
                endDate: req.query.endDate,
            });
        }
        const data = await qb.orderBy("s.created_at", "DESC").getMany();
        res.status(200).json({
            data,
            status: 200,
            success: true,
        });
    }
    catch (error) {
        next(error);
    }
}, {
    query: {},
}));
//# sourceMappingURL=deposit.js.map