"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customerRoutes = void 0;
const express_1 = require("express");
const controller_1 = require("../controller");
const utils_1 = require("../utils");
exports.customerRoutes = (0, express_1.Router)();
const { createContact, getContacts, updateContact, collectDue, addGranter, uploadDocuments, deposit, } = new controller_1.ContactController();
exports.customerRoutes.route("/").post(createContact).get(getContacts);
exports.customerRoutes.patch("/deposit", deposit);
exports.customerRoutes.route("/:id").patch(updateContact);
exports.customerRoutes.route("/collect-due/:id").patch(collectDue);
exports.customerRoutes.post("/:id/granter", addGranter);
exports.customerRoutes.post("/:id/document", utils_1.uploadImage.array("documents"), uploadDocuments);
//# sourceMappingURL=customer.js.map