"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.appDataSource = void 0;
const typeorm_1 = require("typeorm");
const config_1 = __importDefault(require("./config"));
const entities_1 = require("./entities");
const volatile_product_1 = require("./entities/volatile-product");
const costing_1 = require("./entities/costing");
const factory_1 = require("./entities/factory");
const opening_quantity_1 = require("./entities/opening-quantity");
const FactoryVolatileProduct_1 = require("./entities/FactoryVolatileProduct");
const wastage_1 = require("./entities/wastage");
const wastage_product_1 = require("./entities/wastage-product");
const slot_1 = require("./entities/slot");
const production_product_1 = require("./entities/production-product");
const delivery_product_1 = require("./entities/delivery-product");
exports.appDataSource = new typeorm_1.DataSource({
    type: "mysql",
    username: config_1.default.DB_USER,
    password: config_1.default.DB_PASS,
    port: config_1.default.DB_PORT,
    database: config_1.default.DB_NAME,
    entities: [
        entities_1.User,
        entities_1.Role,
        entities_1.PaymentDetails,
        entities_1.Customer,
        entities_1.Image,
        entities_1.Business,
        entities_1.Payment,
        entities_1.Granter,
        entities_1.Supplier,
        entities_1.Account,
        entities_1.AccountHistory,
        entities_1.Expense,
        entities_1.ExpenseType,
        entities_1.SavingDeposit,
        entities_1.Income,
        entities_1.IncomeType,
        entities_1.SavingsWithdraw,
        entities_1.AmountTransfer,
        entities_1.Product,
        entities_1.LcAgent,
        entities_1.Project,
        entities_1.Delivery,
        entities_1.PlanProject,
        entities_1.Production,
        volatile_product_1.VolatileProduct,
        entities_1.Documents,
        costing_1.Costing,
        factory_1.Factory,
        opening_quantity_1.OpeningQuantity,
        FactoryVolatileProduct_1.FactoryVolatileProduct,
        wastage_1.Wastage,
        wastage_product_1.WastageProduct,
        slot_1.Slot,
        production_product_1.ProductionProduct,
        delivery_product_1.DeliveryProduct,
    ],
    synchronize: true,
    host: config_1.default.DB_HOST,
});
//# sourceMappingURL=orm.config.js.map