"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.permissions = exports.isAuthenticated = void 0;
const jwt = __importStar(require("jsonwebtoken"));
const config_1 = __importDefault(require("../config"));
const controller_1 = require("../controller");
const utils_1 = require("../utils");
exports.isAuthenticated = (0, utils_1.requestHandler)(async (req, res, next) => {
    try {
        let token;
        const authorizationHeader = req.headers.authorization;
        const cookies = req.cookies;
        if (authorizationHeader) {
            const parts = authorizationHeader.split(" ");
            if (parts.length === 2 && parts[0] === "Bearer") {
                token = parts[1];
            }
        }
        if ((!token || token === "undefined" || token === "null") && cookies) {
            token = cookies["__auth_token"] || cookies["__auth"];
        }
        const userController = new controller_1.UserController();
        if (!token) {
            return (0, utils_1.ApiError)("Unauthorized Access", 401, next);
        }
        const decodedData = jwt.verify(token, config_1.default.JWT_SECRET);
        const user = await userController.findUserById(decodedData.sub);
        if (!user) {
            return (0, utils_1.ApiError)("Unauthorized Access", 401, next);
        }
        req.user = user;
        next();
    }
    catch (err) {
        console.log(err);
        return (0, utils_1.ApiError)("Unauthorized Access", 401, next);
    }
});
exports.permissions = [
    "user",
    "user.view",
    "user.create",
    "user.update",
    "user.delete",
    "roles.create",
    "roles.view",
    "product",
    "roles.update",
    "product.view",
    "product.delete",
    "product.update",
    "product.create",
    "category.create",
    "category.view",
    "category.update",
    "category.delete",
    "brand.create",
    "brand.view",
    "brand.update",
    "brand.delete",
    "color.create",
    "color.view",
    "color.update",
    "color.delete",
    "product-group.create",
    "product-group.view",
    "product-group.update",
    "product-group.delete",
    "model.create",
    "model.view",
    "model.update",
    "model.delete",
    "unit.create",
    "unit.view",
    "unit.update",
    "unit.delete",
    "sales",
    "sales.create",
    "sales.view",
    "contact",
    "contact.view",
    "contact.update",
    "contact.delete",
    "contact.create",
    "report.view",
    "purchase.create",
    "purchase.view",
    "product.transfer",
    "finance",
    "finance.view",
    "settings",
    "dashboard.view",
];
// export const authorizedRoles = (...permission: Permission[]) => {
//     return requestHandler(async (req, res, next) => {
//         if (req.user?.role === "admin") {
//             next();
//         } else {
//             const permissionArr = req.user?.accessController?.hasPermission.split(
//                 ","
//             ) as Permission[];
//
//             if (!permissionArr?.length) {
//                 return ApiError("Unauthorized Access", 401, next);
//             }
//
//             const hasPermission = permissionArr.some((p) => permission.includes(p));
//             if (hasPermission) {
//                 next();
//             } else {
//                 return ApiError("Unauthorized Access", 401, next);
//             }
//         }
//     });
// };
//# sourceMappingURL=isAuth.js.map