"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const config_1 = __importDefault(require("../config"));
function errorMiddleware(err, _req, res, _next) {
    err.statusCode = err.statusCode || 500;
    err.message = err.message || "Server Error";
    if (config_1.default.NODE_ENV === "production") {
        process.stderr.write("==================== \n" +
            "Error: " +
            err.message +
            "\n" +
            "Stack: " +
            err.stack +
            "\n" +
            "==================== \n");
    }
    return res.status(err.statusCode).json({
        success: false,
        status: err.statusCode,
        error: err.message
    });
}
exports.default = errorMiddleware;
//# sourceMappingURL=err.js.map