"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const cors_1 = __importDefault(require("cors"));
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const config_1 = __importDefault(require("./config"));
const err_1 = __importDefault(require("./middleware/err"));
const isAuth_1 = require("./middleware/isAuth");
const orm_config_1 = require("./orm.config");
const routes_1 = require("./routes");
const deposit_1 = require("./routes/deposit");
const income_type_1 = require("./routes/income-type");
const reports_1 = require("./routes/reports");
const role_1 = require("./routes/role");
const factory_1 = require("./routes/factory");
const mount = async (app) => {
    orm_config_1.appDataSource
        .initialize()
        .then(async () => {
        await orm_config_1.appDataSource.query(`SET GLOBAL time_zone = '+06:00';`);
        await orm_config_1.appDataSource.query(`SET time_zone = '+06:00';`);
    })
        .catch((err) => console.log(err));
    app.use((0, cors_1.default)());
    app.use(express_1.default.json());
    app.use(express_1.default.urlencoded({ extended: true, limit: "100mb" }));
    // Define the path to your uploads folder containing images
    const uploadFolderPath = path_1.default.join(__dirname, "../", "uploads");
    // Serve the uploads folder statically
    app.use("/api/v1/uploads", express_1.default.static(uploadFolderPath));
    app.use("/api/v1/users", routes_1.userRoutes);
    app.use("/api/v1/contacts", isAuth_1.isAuthenticated, routes_1.customerRoutes);
    app.use("/api/v1/business", isAuth_1.isAuthenticated, routes_1.businessRoutes);
    app.use("/api/v1/roles", isAuth_1.isAuthenticated, role_1.roleRoutes);
    app.use("/api/v1/accounts", isAuth_1.isAuthenticated, routes_1.accountRoutes);
    app.use("/api/v1/expense", isAuth_1.isAuthenticated, routes_1.expenseRoutes);
    app.use("/api/v1/expense-types", isAuth_1.isAuthenticated, routes_1.expenseTypeRoutes);
    app.use("/api/v1/payments", isAuth_1.isAuthenticated, routes_1.paymentRoutes);
    app.use("/api/v1/saving-deposits", isAuth_1.isAuthenticated, deposit_1.depositRoutes);
    app.use("/api/v1/income-type", isAuth_1.isAuthenticated, income_type_1.incomeTypeRoutes);
    app.use("/api/v1/income", isAuth_1.isAuthenticated, routes_1.incomeRoutes);
    app.use("/api/v1/withdraw", isAuth_1.isAuthenticated, routes_1.savingsWithdrawRoutes);
    app.use("/api/v1/reports", isAuth_1.isAuthenticated, reports_1.reportRoutes);
    app.use("/api/v1/products", isAuth_1.isAuthenticated, routes_1.productRoutes);
    app.use("/api/v1/lc-agents", isAuth_1.isAuthenticated, routes_1.lgAgentRoutes);
    app.use("/api/v1/projects", isAuth_1.isAuthenticated, routes_1.projectRoutes);
    app.use("/api/v1/productions", isAuth_1.isAuthenticated, routes_1.productionRoutes);
    app.use("/api/v1/plans", isAuth_1.isAuthenticated, routes_1.planRoutes);
    app.use("/api/v1/costings", isAuth_1.isAuthenticated, routes_1.costingRoutes);
    app.use("/api/v1/factory", isAuth_1.isAuthenticated, factory_1.factoryRoutes);
    app.use("/api/v1/wastage", isAuth_1.isAuthenticated, routes_1.wastageRoutes);
    app.get("/api/v1/healthz", (_req, res) => {
        res.status(200).json({ status: "ok" });
    });
    // Error middleware
    app.use(err_1.default);
    const server = app.listen(config_1.default.PORT, "0.0.0.0", () => {
        console.log(`Development Server Started on PORT: ${config_1.default.PORT}`);
    });
};
mount((0, express_1.default)()).catch((e) => console.log(e));
//# sourceMappingURL=index.js.map