"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Delivery = exports.Project = void 0;
const typeorm_1 = require("typeorm");
const costing_1 = require("./costing");
const customer_1 = require("./customer");
const documents_1 = require("./documents");
const paymentoption_1 = require("./paymentoption");
const plan_project_1 = require("./plan-project");
const production_1 = require("./production");
const volatile_product_1 = require("./volatile-product");
const factory_1 = require("./factory");
const wastage_1 = require("./wastage");
const slot_1 = require("./slot");
const delivery_product_1 = require("./delivery-product");
let Project = class Project {
    id;
    projectName;
    customer;
    slots;
    costings;
    wastages;
    quantity;
    totalAmount;
    paidAmount;
    dueAmount;
    address;
    planProject;
    payments;
    productions;
    deliveries;
    documents;
    createdAt;
};
exports.Project = Project;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Project.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Project.prototype, "projectName", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => customer_1.Customer, { eager: true }),
    __metadata("design:type", customer_1.Customer)
], Project.prototype, "customer", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => slot_1.Slot, (s) => s.project, {
        eager: true,
    }),
    __metadata("design:type", Array)
], Project.prototype, "slots", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => costing_1.Costing, (c) => c.project, {
        eager: true,
    }),
    __metadata("design:type", Array)
], Project.prototype, "costings", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => wastage_1.Wastage, (w) => w.project),
    __metadata("design:type", Array)
], Project.prototype, "wastages", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], Project.prototype, "quantity", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "bigint",
        transformer: {
            to: (value) => value.toString(), // Store as string in database
            from: (value) => Number(value), // Convert from string to BigInt when retrieving from database
        },
    }),
    __metadata("design:type", Number)
], Project.prototype, "totalAmount", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "bigint",
        transformer: {
            to: (value) => value.toString(),
            from: (value) => Number(value),
        },
    }),
    __metadata("design:type", Number)
], Project.prototype, "paidAmount", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "bigint",
        transformer: {
            to: (value) => value.toString(),
            from: (value) => Number(value),
        },
    }),
    __metadata("design:type", Number)
], Project.prototype, "dueAmount", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Project.prototype, "address", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => plan_project_1.PlanProject, (p) => p.project),
    __metadata("design:type", Array)
], Project.prototype, "planProject", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => paymentoption_1.Payment, (p) => p.project, {
        eager: true,
    }),
    __metadata("design:type", Array)
], Project.prototype, "payments", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => production_1.Production, (p) => p.project, {
        eager: true,
    }),
    __metadata("design:type", Array)
], Project.prototype, "productions", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => Delivery, (d) => d.project, {
        eager: true,
        cascade: true,
        onDelete: "CASCADE",
    }),
    __metadata("design:type", Array)
], Project.prototype, "deliveries", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => documents_1.Documents, (d) => d.project, {
        eager: true,
    }),
    __metadata("design:type", Array)
], Project.prototype, "documents", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Project.prototype, "createdAt", void 0);
exports.Project = Project = __decorate([
    (0, typeorm_1.Entity)()
], Project);
let Delivery = class Delivery {
    id;
    quantity;
    project;
    products;
    deliveryProducts;
    customer;
    challanNumber;
    trackNumber;
    status;
    documents;
    factory;
    url;
    createAt;
};
exports.Delivery = Delivery;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Delivery.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], Delivery.prototype, "quantity", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => Project, (p) => p.deliveries),
    __metadata("design:type", Project)
], Delivery.prototype, "project", void 0);
__decorate([
    (0, typeorm_1.ManyToMany)(() => volatile_product_1.VolatileProduct),
    (0, typeorm_1.JoinTable)({
        name: "delivery_products",
    }),
    __metadata("design:type", Array)
], Delivery.prototype, "products", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => delivery_product_1.DeliveryProduct, (d) => d.delivery, {
        eager: true,
    }),
    __metadata("design:type", Array)
], Delivery.prototype, "deliveryProducts", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => customer_1.Customer),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", customer_1.Customer)
], Delivery.prototype, "customer", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Delivery.prototype, "challanNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Delivery.prototype, "trackNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: "ON_THE_WAY" }),
    __metadata("design:type", String)
], Delivery.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => documents_1.Documents, (d) => d.delivery, {
        eager: true,
    }),
    __metadata("design:type", Array)
], Delivery.prototype, "documents", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => factory_1.Factory, (f) => f.deliveries),
    __metadata("design:type", factory_1.Factory)
], Delivery.prototype, "factory", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Delivery.prototype, "url", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Delivery.prototype, "createAt", void 0);
exports.Delivery = Delivery = __decorate([
    (0, typeorm_1.Entity)()
], Delivery);
//# sourceMappingURL=project.js.map