"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Production = exports.Shift = void 0;
const typeorm_1 = require("typeorm");
const project_1 = require("./project");
const customer_1 = require("./customer");
const factory_1 = require("./factory");
const production_product_1 = require("./production-product");
var Shift;
(function (Shift) {
    Shift["DAY"] = "DAY";
    Shift["NIGHT"] = "NIGHT";
})(Shift || (exports.Shift = Shift = {}));
let Production = class Production {
    id;
    quantity;
    project;
    products;
    customer;
    dayShift;
    nightShift;
    factory;
    createdAt;
};
exports.Production = Production;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Production.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", Number)
], Production.prototype, "quantity", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => project_1.Project, (p) => p.productions, { nullable: true }),
    __metadata("design:type", project_1.Project)
], Production.prototype, "project", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => production_product_1.ProductionProduct, (p) => p.production, { eager: true }),
    __metadata("design:type", Array)
], Production.prototype, "products", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => customer_1.Customer, { eager: true }),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", customer_1.Customer)
], Production.prototype, "customer", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], Production.prototype, "dayShift", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], Production.prototype, "nightShift", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => factory_1.Factory, (f) => f.productions),
    __metadata("design:type", factory_1.Factory)
], Production.prototype, "factory", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Production.prototype, "createdAt", void 0);
exports.Production = Production = __decorate([
    (0, typeorm_1.Entity)()
], Production);
//# sourceMappingURL=production.js.map