"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Customer = void 0;
const typeorm_1 = require("typeorm");
const granter_1 = require("./granter");
const paymentoption_1 = require("./paymentoption");
const saving_deposit_1 = require("./saving-deposit");
const wastage_1 = require("./wastage");
let Customer = class Customer extends typeorm_1.BaseEntity {
    id;
    account_number;
    name;
    company_name;
    email;
    mobile;
    wastages;
    designation;
    alternative_name;
    alternative_mobile;
    opening_balance;
    credit_limit;
    address;
    husband_or_parent_name;
    savings;
    is_hire_account_closed;
    due;
    religion;
    nid;
    profession;
    nationality;
    payments;
    granter;
    documents;
    approved;
    installment_period;
    seasonal_approved;
    savingDeposit;
    savingsCustomer;
    created_at;
    updated_at;
};
exports.Customer = Customer;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Customer.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "account_number", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Customer.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Customer.prototype, "company_name", void 0);
__decorate([
    (0, typeorm_1.Column)({ unique: true, nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "email", void 0);
__decorate([
    (0, typeorm_1.Column)({ unique: true }),
    __metadata("design:type", String)
], Customer.prototype, "mobile", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => wastage_1.Wastage, (w) => w.customer),
    __metadata("design:type", Array)
], Customer.prototype, "wastages", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Customer.prototype, "designation", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "alternative_name", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "alternative_mobile", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "bigint",
        transformer: {
            to: (v) => v.toString(),
            from: (v) => parseInt(v),
        },
    }),
    __metadata("design:type", Number)
], Customer.prototype, "opening_balance", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "bigint",
        transformer: {
            to: (v) => v.toString(),
            from: (v) => parseInt(v),
        },
    }),
    __metadata("design:type", Number)
], Customer.prototype, "credit_limit", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "address", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "husband_or_parent_name", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: "bigint",
        transformer: {
            to: (v) => v.toString(),
            from: (v) => parseInt(v),
        },
    }),
    __metadata("design:type", Number)
], Customer.prototype, "savings", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: false }),
    __metadata("design:type", Boolean)
], Customer.prototype, "is_hire_account_closed", void 0);
__decorate([
    (0, typeorm_1.Column)({
        nullable: true,
        default: 0,
        type: "bigint",
        transformer: {
            to: (value) => value.toString(), // Store as string in database
            from: (value) => Number(value), // Convert from string to BigInt when retrieving from database
        },
    }),
    __metadata("design:type", Number)
], Customer.prototype, "due", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "religion", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "nid", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "profession", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Customer.prototype, "nationality", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => paymentoption_1.Payment, (p) => p.customer),
    __metadata("design:type", Array)
], Customer.prototype, "payments", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => granter_1.Granter, (g) => g.customer, {
        onDelete: "RESTRICT",
        onUpdate: "CASCADE",
        eager: true,
    }),
    __metadata("design:type", Array)
], Customer.prototype, "granter", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: "text" }),
    __metadata("design:type", String)
], Customer.prototype, "documents", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], Customer.prototype, "approved", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], Customer.prototype, "installment_period", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: false }),
    __metadata("design:type", Boolean)
], Customer.prototype, "seasonal_approved", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => saving_deposit_1.SavingDeposit, (savingDeposit) => savingDeposit.customer, {
        onUpdate: "CASCADE",
        onDelete: "RESTRICT",
    }),
    __metadata("design:type", Array)
], Customer.prototype, "savingDeposit", void 0);
__decorate([
    (0, typeorm_1.Column)({
        default: false,
    }),
    __metadata("design:type", Boolean)
], Customer.prototype, "savingsCustomer", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Customer.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], Customer.prototype, "updated_at", void 0);
exports.Customer = Customer = __decorate([
    (0, typeorm_1.Entity)()
], Customer);
//# sourceMappingURL=customer.js.map