"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountState = exports.AccountType = void 0;
const typeorm_1 = require("typeorm");
const account_history_1 = require("./account-history");
var AccountType;
(function (AccountType) {
    AccountType["CASH"] = "CASH";
    AccountType["BANK"] = "BANK";
    AccountType["BKASH"] = "BKASH";
    AccountType["ROCKET"] = "ROCKET";
    AccountType["NAGAD"] = "NAGAD";
})(AccountType || (exports.AccountType = AccountType = {}));
var AccountState;
(function (AccountState) {
    AccountState["ACTIVE"] = "ACTIVE";
    AccountState["CLOSED"] = "CLOSED";
})(AccountState || (exports.AccountState = AccountState = {}));
let Account = class Account {
    id;
    accountName;
    accountNumber;
    bankName;
    accountType;
    default;
    accountState;
    accountHistory;
    balance;
    createdAt;
    updatedAt;
};
exports.Account = Account;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], Account.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Account.prototype, "accountName", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Account.prototype, "accountNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Account.prototype, "bankName", void 0);
__decorate([
    (0, typeorm_1.Column)({ enum: AccountType, type: "enum" }),
    __metadata("design:type", String)
], Account.prototype, "accountType", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: false }),
    __metadata("design:type", Boolean)
], Account.prototype, "default", void 0);
__decorate([
    (0, typeorm_1.Column)({ enum: AccountState, type: "enum", nullable: true }),
    __metadata("design:type", String)
], Account.prototype, "accountState", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => account_history_1.AccountHistory, (ac) => ac.account, {
        onUpdate: "CASCADE",
        onDelete: "RESTRICT",
        eager: true,
    }),
    __metadata("design:type", Array)
], Account.prototype, "accountHistory", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], Account.prototype, "balance", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Account.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], Account.prototype, "updatedAt", void 0);
exports.Account = Account = __decorate([
    (0, typeorm_1.Entity)()
], Account);
//# sourceMappingURL=account.js.map