"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountHistory = exports.TransactionType = void 0;
const typeorm_1 = require("typeorm");
const account_1 = require("./account");
const customer_1 = require("./customer");
var TransactionType;
(function (TransactionType) {
    TransactionType["CREDIT"] = "CREDIT";
    TransactionType["DEBIT"] = "DEBIT";
    TransactionType["OPENING_BALANCE"] = "OPENING_BALANCE";
})(TransactionType || (exports.TransactionType = TransactionType = {}));
let AccountHistory = class AccountHistory {
    id;
    transactionType;
    account;
    customer;
    amount;
    remark;
    type;
    createdAt;
};
exports.AccountHistory = AccountHistory;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Number)
], AccountHistory.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ enum: TransactionType, type: "enum" }),
    __metadata("design:type", String)
], AccountHistory.prototype, "transactionType", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => account_1.Account, (account) => account.accountHistory, {
        cascade: true,
        onUpdate: "CASCADE",
        onDelete: "CASCADE",
    }),
    __metadata("design:type", account_1.Account)
], AccountHistory.prototype, "account", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => customer_1.Customer, {
        cascade: true,
    }),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", customer_1.Customer)
], AccountHistory.prototype, "customer", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "bigint" }),
    __metadata("design:type", Number)
], AccountHistory.prototype, "amount", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], AccountHistory.prototype, "remark", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], AccountHistory.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], AccountHistory.prototype, "createdAt", void 0);
exports.AccountHistory = AccountHistory = __decorate([
    (0, typeorm_1.Entity)()
], AccountHistory);
//# sourceMappingURL=account-history.js.map