"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
const base_1 = require("./base");
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const isAuth_1 = require("../middleware/isAuth");
const bcrypt = __importStar(require("bcryptjs"));
class UserController extends base_1.Controller {
    constructor() {
        super(entities_1.User);
    }
    createAdmin = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            this.validateErr(req.body, "email", "mobile", "password", "name", "businessName");
            const business = new entities_1.Business();
            business.name = req.body.businessName;
            const user = new entities_1.User();
            if (req.body.secret !== "pos@123") {
                throw new Error("Invalid Secret Key");
            }
            user.access = await this.adminAccessController();
            user.role = entities_1.UserRole.ADMIN;
            user.business = business;
            Object.assign(user, req.body);
            await this.repository.save(user);
            return this.success(res, user, 201);
        }
        catch (err) {
            return (0, utils_1.ApiError)(err, 400, next);
        }
    }, {
        body: {},
    });
    createUser = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            this.validateErr(req.body, "email", "mobile", "password", "name", "roleId");
            const admin = req.user;
            if (!admin || admin.role !== entities_1.UserRole.ADMIN) {
                throw new Error("Unauthorized");
            }
            const user = new entities_1.User();
            user.access = await this.userAccessController(req.body.roleId);
            Object.assign(user, req.body);
            user.role = entities_1.UserRole.USER;
            user.business = admin.business;
            await this.repository.save(user);
            return this.success(res, user, 201);
        }
        catch (err) {
            return (0, utils_1.ApiError)(err, 400, next);
        }
    }, {
        body: {},
    });
    getUser = (0, utils_1.requestHandler)(async (req, res, next) => {
        const user = await this.repository.find({
            relations: {
                access: true,
            },
        });
        return this.success(res, user);
    });
    loginUser = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            const { identity } = req.body;
            if (!identity.length) {
                return (0, utils_1.ApiError)("Please Enter a valid mobile or email", 404, next);
            }
            const user = await this.repository.findOne({
                where: identity.includes("@")
                    ? { email: identity }
                    : { mobile: identity },
                relations: {
                    access: true,
                },
            });
            if (!user) {
                return (0, utils_1.ApiError)("Invalid username or password", 404, next);
            }
            // Checking If User IS Verified
            // Checking If User IS Created By Google Or Facebook
            // Checking If Password Match
            if (user.password && req.body.password) {
                const isPasswordMatch = bcrypt.compareSync(req.body.password, user.password);
                console.log(isPasswordMatch);
                if (!isPasswordMatch) {
                    return (0, utils_1.ApiError)("Invalid username or password", 404, next);
                }
            }
            (0, utils_1.sendToken)(res, user, next);
        }
        catch (err) {
            return (0, utils_1.ApiError)(err.message, 404, next);
        }
    }, {
        body: {
            identity: String.toString(),
            password: String.toString(),
        },
    });
    currentUser = (0, utils_1.requestHandler)(async (req, res, next) => {
        if (!req.user) {
            return (0, utils_1.ApiError)("Unauthorized access", 404, next);
        }
        return this.success(res, req.user);
    });
    findUserById = async (id) => {
        const user = await this.repository
            .createQueryBuilder("u")
            .where("u.id = :id", { id })
            .leftJoinAndSelect("u.business", "b")
            .getOneOrFail();
        return user;
    };
    async userAccessController(id) {
        const rolesExist = await this.getRepository(entities_1.Role)
            .createQueryBuilder()
            .where("id=:id", { id: parseInt(id.toString()) })
            .getOne();
        if (rolesExist) {
            return rolesExist;
        }
        const role = new entities_1.Role();
        role.name = "User";
        role.hasAccess = "";
        return role;
    }
    async adminAccessController() {
        const rolesExist = await this.getRepository(entities_1.Role)
            .createQueryBuilder()
            .where("name ='Admin'")
            .getOne();
        if (rolesExist) {
            return rolesExist;
        }
        const role = new entities_1.Role();
        role.name = "Admin";
        role.hasAccess = isAuth_1.permissions.join(",");
        return role;
    }
}
exports.UserController = UserController;
//# sourceMappingURL=user.js.map