"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleController = void 0;
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const base_1 = require("./base");
class RoleController extends base_1.Controller {
    constructor() {
        super(entities_1.Role);
    }
    createRole = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            this.validateErr(req.body, "hasAccess", "name");
            const role = new entities_1.Role();
            Object.assign(role, req.body);
            await this.repository.save(role);
            return this.success(res, role, 201);
        }
        catch (err) {
            return (0, utils_1.ApiError)(err, 400, next);
        }
    }, {
        body: {},
    });
    getRoles = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            const roles = await this.repository.find();
            return this.success(res, roles);
        }
        catch (err) {
            return (0, utils_1.ApiError)(err, 400, next);
        }
    });
}
exports.RoleController = RoleController;
//# sourceMappingURL=role.js.map