"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductionController = void 0;
const date_fns_tz_1 = require("date-fns-tz");
const typeorm_1 = require("typeorm");
const entities_1 = require("../entities");
const factory_1 = require("../entities/factory");
const FactoryVolatileProduct_1 = require("../entities/FactoryVolatileProduct");
const production_product_1 = require("../entities/production-product");
const utils_1 = require("../utils");
const base_1 = require("./base");
class ProductionController extends base_1.Controller {
    constructor() {
        super(entities_1.Production);
    }
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        this.validateErr(req.body, "products", "quantity", "factoryId");
        const factory = await this.getRepository(factory_1.Factory).findOne({
            where: {
                id: req.body.factoryId,
            },
        });
        if (!factory) {
            return this.failed("Factory not found", next);
        }
        const productionProduct = await Promise.all(req.body.products.map(async (p) => {
            const newProduct = new production_product_1.ProductionProduct();
            newProduct.name = p.name;
            newProduct.quantity = p.quantity;
            newProduct.originalId = p.id;
            const product = await this.getRepository(entities_1.Product).findOne({
                where: {
                    id: p.id,
                },
            });
            console.log(product);
            if (!product) {
                throw new Error("Someing went wrong while creating produciton product");
            }
            const volatile = await this.getRepository(FactoryVolatileProduct_1.FactoryVolatileProduct).findOne({
                where: {
                    factory: {
                        id: factory.id,
                    },
                    originalId: product.id,
                },
            });
            if (!volatile) {
                throw new Error("Someing went wrong while creating produciton product");
            }
            volatile.stock = Number(volatile.stock) + Number(p.quantity);
            product.stock += parseInt(p.quantity);
            await this.getRepository(FactoryVolatileProduct_1.FactoryVolatileProduct).save(volatile);
            await this.getRepository(entities_1.Product).save(product);
            return await this.getRepository(production_product_1.ProductionProduct).save(newProduct);
        }));
        const production = new entities_1.Production();
        if (req.body.projectId) {
            const project = await this.getRepository(entities_1.Project).findOne({
                where: {
                    id: req.body.projectId,
                },
            });
            if (!project) {
                return this.failed("Project not found", next);
            }
            production.project = project;
        }
        if (req.body.customerId) {
            const project = await this.getRepository(entities_1.Customer).findOne({
                where: {
                    id: req.body.customerId,
                },
            });
            if (!project) {
                return this.failed("Project not found", next);
            }
            production.customer = project;
        }
        if (req.body.productionDate) {
            const parsedDate = new Date(req.body.productionDate);
            if (!isNaN(parsedDate.getTime())) {
                production.createdAt = (0, date_fns_tz_1.toZonedTime)(req.body.productionDate, "Asia/Dhaka", {
                    timeZone: "Asia/Dhaka",
                });
            }
            else {
                // Handle invalid date if needed
                return this.failed("Invalid date format", next);
            }
        }
        production.products = productionProduct;
        production.quantity = req.body.quantity;
        production.factory = factory;
        if (req.body.shift === "day") {
            production.dayShift = parseInt(req.body.quantity) || 0;
        }
        else {
            production.nightShift = parseInt(req.body.quantity) || 0;
        }
        await this.getRepository(entities_1.Production).save(production);
        this.success(res, production);
    }, { body: {} });
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        let where = {};
        if (req.query.startDate && req.query.endDate) {
            // Convert the endDate to 23:59:59
            let endDate = new Date(req.query.endDate);
            endDate.setHours(23, 59, 59, 999);
            where.createdAt = (0, typeorm_1.Between)(req.query.startDate, endDate);
        }
        const production = await this.repository.find({
            relations: {
                customer: true,
                project: true,
                factory: {
                    productions: false,
                    deliveries: false
                },
            },
            order: {
                createdAt: "DESC",
            },
            where,
        });
        this.success(res, production);
    }, {
        query: {},
    });
}
exports.ProductionController = ProductionController;
//# sourceMappingURL=production.js.map