"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlanController = void 0;
const entities_1 = require("../entities");
const volatile_product_1 = require("../entities/volatile-product");
const utils_1 = require("../utils");
const base_1 = require("./base");
class PlanController extends base_1.Controller {
    constructor() {
        super(entities_1.PlanProject);
    }
    creatPlan = (0, utils_1.requestHandler)(async (req, res, next) => {
        this.validateErr(req.body, "startDate", "endDate", "projectId", "productId", "weeklyDayOff", "customerId");
        const project = await this.getRepository(entities_1.Project).findOne({
            where: {
                id: req.body.projectId,
            },
        });
        const customer = await this.getRepository(entities_1.Customer).findOne({
            where: {
                id: req.body.customerId,
            },
        });
        const product = await this.getRepository(volatile_product_1.VolatileProduct).findOne({
            where: {
                id: req.body.productId,
            },
        });
        if (!customer) {
            return this.failed("Customer not found", next);
        }
        if (!project) {
            return this.failed("Project not found", next);
        }
        if (!product) {
            return this.failed("Product not found", next);
        }
        const dayCount = this.countDaysExcludingFridays(req.body.startDate, req.body.endDate, req.body.weeklyDayOff);
        const plan = new entities_1.PlanProject();
        plan.product = product;
        plan.project = project;
        plan.productionPerDay = Math.round(product.quantity / dayCount);
        plan.startDate = req.body.startDate;
        plan.endDate = req.body.endDate;
        plan.dayCount = dayCount;
        plan.customer = customer;
        await this.repository.save(plan);
        this.success(res, plan, 201);
    }, {
        body: {},
    });
    getPlan = (0, utils_1.requestHandler)(async (req, res, next) => {
        const plan = await this.repository.find({
            relations: {
                product: true,
                project: true,
                customer: true
            },
        });
        this.success(res, plan);
    });
    countDaysExcludingFridays(startDate, endDate, weeklyDayOff) {
        // Convert start and end dates to Date objects
        const start = new Date(startDate);
        const end = new Date(endDate);
        let count = 0;
        // Loop through each day from startDate to endDate
        while (start <= end) {
            // Check if the current day is not a Friday (Day 5 in JavaScript's Date.getDay())
            if (start.getDay() !== 5 || !weeklyDayOff) {
                count++;
            }
            // Move to the next day
            start.setDate(start.getDate() + 1);
        }
        return count;
    }
}
exports.PlanController = PlanController;
//# sourceMappingURL=plan-project.js.map