"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentController = void 0;
const typeorm_1 = require("typeorm");
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const base_1 = require("./base");
class PaymentController extends base_1.Controller {
    constructor() {
        super(entities_1.Payment);
    }
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            let where = {};
            if (req.query.startDate && req.query.endDate) {
                // Convert the endDate to 23:59:59
                let endDate = new Date(req.query.endDate);
                endDate.setHours(23, 59, 59, 999);
                where.created_at = (0, typeorm_1.Between)(req.query.startDate, endDate);
            }
            const payments = await this.repository.find({
                relations: {
                    account: true,
                    project: true,
                    customer: true,
                },
                order: {
                    created_at: "DESC",
                },
                where,
            });
            return this.success(res, payments);
        }
        catch (err) {
            return this.failed(err, next);
        }
    }, {
        query: {},
    });
}
exports.PaymentController = PaymentController;
//# sourceMappingURL=payments.js.map