"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LcAgentController = void 0;
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const base_1 = require("./base");
class LcAgentController extends base_1.Controller {
    constructor() {
        super(entities_1.LcAgent);
    }
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        this.validateErr(req.body, "name", "companyName", "designation", "mobile");
        const lcAgent = await this.repository.save(req.body);
        this.success(res, lcAgent, 201);
    }, {
        body: {},
    });
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        const data = await this.repository.find();
        return this.success(res, data);
    });
}
exports.LcAgentController = LcAgentController;
//# sourceMappingURL=lc-agent.js.map