"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncomeTypeController = void 0;
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const base_1 = require("./base");
class IncomeTypeController extends base_1.Controller {
    constructor() {
        super(entities_1.IncomeType);
    }
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            const incomeType = await this.repository.find();
            return this.success(res, incomeType);
        }
        catch (error) {
            return this.failed(error, next);
        }
    });
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            this.validateErr(req.body, "type", "remark");
            const incomeType = new entities_1.IncomeType();
            Object.assign(incomeType, req.body);
            await this.repository.save(incomeType);
            return this.success(res, incomeType, 201);
        }
        catch (err) {
            return this.failed(err, next);
        }
    }, {
        body: {},
    });
}
exports.IncomeTypeController = IncomeTypeController;
//# sourceMappingURL=income-type.js.map