"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncomeController = void 0;
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const account_1 = require("./account");
const base_1 = require("./base");
class IncomeController extends base_1.Controller {
    constructor() {
        super(entities_1.Income);
    }
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            this.validateErr(req.body, "amount", "incomeTypeId", "accountId");
            const incomeType = await this.getRepository(entities_1.IncomeType).findOne({
                where: {
                    id: req.body.incomeTypeId,
                },
            });
            if (!incomeType) {
                return this.failed("Income Type not found", next);
            }
            const cost = parseInt(req.body.cost) || 0;
            const income = new entities_1.Income();
            income.amount = parseInt(req.body.amount);
            income.incomeType = incomeType;
            income.cost = cost;
            await account_1.AccountController.updateBalance(income.amount - cost, req.body.accountId, entities_1.TransactionType.CREDIT, incomeType.type, req.body.remark
                ? req.body.remark
                : incomeType.remark
                    ? incomeType.remark
                    : "");
            await this.getRepository(entities_1.Income).save(income);
            return this.success(res, income, 201);
        }
        catch (error) {
            return this.failed(error, next);
        }
    }, {
        body: {},
    });
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            const income = await this.repository
                .createQueryBuilder("income")
                .leftJoinAndSelect("income.incomeType", "incomeType")
                .select([
                "income.id",
                "income.amount",
                "incomeType.type",
                "incomeType.remark",
            ])
                .orderBy("income.id", "DESC")
                .getMany();
            return this.success(res, income);
        }
        catch (error) {
            return this.failed(error, next);
        }
    });
}
exports.IncomeController = IncomeController;
//# sourceMappingURL=income-others.js.map