"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FactoryController = void 0;
const factory_1 = require("../entities/factory");
const utils_1 = require("../utils");
const base_1 = require("./base");
class FactoryController extends base_1.Controller {
    constructor() {
        super(factory_1.Factory);
    }
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        this.validateErr(req.body, "name", "address");
        const factory = this.repository.create(req.body);
        await this.repository.save(factory);
        this.success(res, factory);
    }, {
        body: {},
    });
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        const data = await this.repository.find({
            order: {
                createdAt: 'asc'
            }
        });
        return this.success(res, data);
    });
}
exports.FactoryController = FactoryController;
//# sourceMappingURL=factory.js.map