"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpenseController = void 0;
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const account_1 = require("./account");
const base_1 = require("./base");
class ExpenseController extends base_1.Controller {
    constructor() {
        super(entities_1.Expense);
    }
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            this.validateErr(req.body, "amount", "expenseTypeId", "expenseName", "accountId");
            const expenseType = await this.getRepository(entities_1.ExpenseType).findOne({
                where: {
                    id: Number(req.body.expenseTypeId),
                },
            });
            if (!expenseType) {
                throw new utils_1.ErrorHandler("Expense type not found", 404);
            }
            const expense = new entities_1.Expense();
            if (req.file) {
                expense.attachment = req.file.filename;
            }
            Object.assign(expense, req.body);
            expense.expenseType = expenseType;
            await account_1.AccountController.updateBalance(expense.amount, req.body.accountId, entities_1.TransactionType.DEBIT, expense.expenseType.type, expense.expenseName);
            await this.repository.save(expense);
            return this.success(res, expense, 201);
        }
        catch (error) {
            this.failed(error, next);
        }
    }, {
        body: {},
    });
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            const expense = await this.repository.find();
            return this.success(res, expense);
        }
        catch (err) {
            this.failed(err, next);
        }
    });
}
exports.ExpenseController = ExpenseController;
//# sourceMappingURL=expense.js.map