"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpenseTypeController = void 0;
const entities_1 = require("../entities");
const utils_1 = require("../utils");
const base_1 = require("./base");
class ExpenseTypeController extends base_1.Controller {
    constructor() {
        super(entities_1.ExpenseType);
    }
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            this.validateErr(req.body, "type");
            const expenseType = new entities_1.ExpenseType();
            expenseType.type = req.body.type;
            await this.repository.save(expenseType);
            this.success(res, expenseType);
        }
        catch (error) {
            this.failed(error, next);
        }
    }, {
        body: { type: "" },
    });
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            const expenseType = await this.repository.find();
            this.success(res, expenseType);
        }
        catch (error) {
            this.failed(error, next);
        }
    });
}
exports.ExpenseTypeController = ExpenseTypeController;
//# sourceMappingURL=expense-type.js.map