"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CostingController = void 0;
const entities_1 = require("../entities");
const costing_1 = require("../entities/costing");
const utils_1 = require("../utils");
const base_1 = require("./base");
class CostingController extends base_1.Controller {
    constructor() {
        super(costing_1.Costing);
    }
    create = (0, utils_1.requestHandler)(async (req, res, next) => {
        this.validateErr(req.body, "projectId", "customerId", "amount");
        const project = await this.getRepository(entities_1.Project).findOne({
            where: {
                id: req.body.projectId,
            },
        });
        const customer = await this.getRepository(entities_1.Customer).findOne({
            where: {
                id: req.body.customerId,
            },
        });
        if (!project) {
            return this.failed("Project not found", next);
        }
        if (!customer) {
            return this.failed("Customer not found", next);
        }
        const costing = new costing_1.Costing();
        costing.project = project;
        costing.customer = customer;
        costing.amount = req.body.amount;
        await this.repository.save(costing);
        return this.success(res, costing, 201);
    }, {
        body: {},
    });
    get = (0, utils_1.requestHandler)(async (req, res, next) => {
        const data = await this.repository.find({
            relations: {
                customer: true,
                project: true,
            },
        });
        return this.success(res, data);
    });
}
exports.CostingController = CostingController;
//# sourceMappingURL=costing.js.map