"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessController = void 0;
const base_1 = require("./base");
const entities_1 = require("../entities");
const utils_1 = require("../utils");
class BusinessController extends base_1.Controller {
    constructor() {
        super(entities_1.Business);
    }
    getBusiness = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            const business = await this.repository
                .createQueryBuilder("b")
                .leftJoinAndSelect("b.users", "u")
                .leftJoinAndSelect("b.products", "p")
                .where("u.id=:userId", { userId: req?.user?.id })
                .cache(true)
                .getMany();
            return this.success(res, business);
        }
        catch (err) {
            return (0, utils_1.ApiError)(err, 404, next);
        }
    });
    deleteBusiness = (0, utils_1.requestHandler)(async (req, res, next) => {
        try {
            if (!req.user) {
                return (0, utils_1.ApiError)("User Not Found", 404, next);
            }
            await this.repository.delete(req.user?.business.id);
            this.success(res, null, 200, "Business Deleted");
        }
        catch (err) {
            return (0, utils_1.ApiError)(err, 404, next);
        }
    });
}
exports.BusinessController = BusinessController;
//# sourceMappingURL=business.js.map