"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controller = void 0;
const orm_config_1 = require("../orm.config");
const utils_1 = require("../utils");
class Controller {
    repository;
    queryRunner;
    constructor(Entity) {
        this.repository = orm_config_1.appDataSource.getRepository(Entity);
        this.queryRunner = orm_config_1.appDataSource.createQueryRunner();
    }
    getRepository = (Entity) => orm_config_1.appDataSource.getRepository(Entity);
    success = (res, data, status = 200, message) => {
        res.status(status).json({
            status,
            success: true,
            message,
            data,
        });
    };
    failed = (err, next, statusCode = 404) => {
        (0, utils_1.ApiError)(err, statusCode, next);
    };
    isValidEnum(enumObject, type) {
        if (!type) {
            return;
        }
        const isValid = Object.values(enumObject).includes(type);
        if (!isValid) {
            const err = `${type.toString()} should be one of ${Object.values(enumObject)}`;
            throw new utils_1.ErrorHandler(err, 404);
        }
    }
    validateErr = (body, ...arr) => {
        const errMessage = [];
        arr.forEach((item) => {
            if (body instanceof Array) {
                for (const obj of body) {
                    if (!obj[item]) {
                        errMessage.push(`${item.toString()} is required`);
                    }
                }
            }
            else {
                if (!body[item]) {
                    errMessage.push(`${item.toString()} is required`);
                }
            }
        });
        if (errMessage.length) {
            throw new utils_1.ErrorHandler(errMessage.join(", "), 404);
        }
    };
}
exports.Controller = Controller;
//# sourceMappingURL=base.js.map